% MEASUREMENT SCIENCE REVIEW -- LaTeX class
% Derived from 'article.cls' file.

\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{MSRarticle}
              [2023/01/30 v4.1
 Measurement Science Review article document class]
\newcommand\@ptsize{}
\newif\if@restonecol
\newif\if@titlepage
\@titlepagefalse
\if@compatibility\else
\DeclareOption{a4paper}
   {\setlength\paperheight {297mm}%
    \setlength\paperwidth  {210mm}}
\DeclareOption{a5paper}
   {\setlength\paperheight {210mm}%
    \setlength\paperwidth  {148mm}}
\DeclareOption{b5paper}
   {\setlength\paperheight {250mm}%
    \setlength\paperwidth  {176mm}}
\DeclareOption{letterpaper}
   {\setlength\paperheight {11in}%
    \setlength\paperwidth  {8.5in}}
\DeclareOption{legalpaper}
   {\setlength\paperheight {14in}%
    \setlength\paperwidth  {8.5in}}
\DeclareOption{executivepaper}
   {\setlength\paperheight {10.5in}%
    \setlength\paperwidth  {7.25in}}
\DeclareOption{landscape}
   {\setlength\@tempdima   {\paperheight}%
    \setlength\paperheight {\paperwidth}%
    \setlength\paperwidth  {\@tempdima}}
\fi
\if@compatibility
  \renewcommand\@ptsize{0}
\else
\DeclareOption{10pt}{\renewcommand\@ptsize{0}}
\fi
\DeclareOption{11pt}{\renewcommand\@ptsize{1}}
\DeclareOption{12pt}{\renewcommand\@ptsize{2}}
\if@compatibility\else
\DeclareOption{oneside}{\@twosidefalse \@mparswitchfalse}
\fi
\DeclareOption{twoside}{\@twosidetrue  \@mparswitchtrue}
\DeclareOption{draft}{\setlength\overfullrule{5pt}}
\if@compatibility\else
\DeclareOption{final}{\setlength\overfullrule{0pt}}
\fi
\DeclareOption{titlepage}{\@titlepagetrue}
\if@compatibility\else
\DeclareOption{notitlepage}{\@titlepagefalse}
\fi
\if@compatibility\else
\DeclareOption{onecolumn}{\@twocolumnfalse}
\fi
\DeclareOption{twocolumn}{\@twocolumntrue}
\DeclareOption{leqno}{\input{leqno.clo}}
\DeclareOption{fleqn}{\input{fleqn.clo}}
\DeclareOption{openbib}{%
  \AtEndOfPackage{%
   \renewcommand\@openbib@code{%
      \advance\leftmargin\bibindent
      \itemindent -\bibindent
      \listparindent \itemindent
      \parsep \z@
      }%
   \renewcommand\newblock{\par}}%
}
\ExecuteOptions{letterpaper,10pt,oneside,twocolumn,final}
\ProcessOptions
\input{size1\@ptsize.clo}
\setlength\lineskip{1\p@}
\setlength\normallineskip{1\p@}
\renewcommand\baselinestretch{}
\setlength\parskip{0\p@ \@plus \p@}
\@lowpenalty   51
\@medpenalty  151
\@highpenalty 301
\setcounter{topnumber}{2}
\renewcommand\topfraction{.7}
\setcounter{bottomnumber}{1}
\renewcommand\bottomfraction{.3}
\setcounter{totalnumber}{3}
\renewcommand\textfraction{.2}
\renewcommand\floatpagefraction{.5}
\setcounter{dbltopnumber}{2}
\renewcommand\dbltopfraction{.7}
\renewcommand\dblfloatpagefraction{.5}
\if@twoside
  \def\ps@headings{%
      \let\@oddfoot\@empty\let\@evenfoot\@empty
      \def\@evenhead{\thepage\hfil\slshape\leftmark}%
      \def\@oddhead{{\slshape\rightmark}\hfil\thepage}%
      \let\@mkboth\markboth
    \def\sectionmark##1{%
      \markboth {\MakeUppercase{%
        \ifnum \c@secnumdepth >\z@
          \thesection\quad
        \fi
        ##1}}{}}%
    \def\subsectionmark##1{%
      \markright {%
        \ifnum \c@secnumdepth >\@ne
          \thesubsection\quad
        \fi
        ##1}}}
\else
  \def\ps@headings{%
    \let\@oddfoot\@empty
    \def\@oddhead{{\slshape\rightmark}\hfil\thepage}%
    \let\@mkboth\markboth
    \def\sectionmark##1{%
      \markright {\MakeUppercase{%
        \ifnum \c@secnumdepth >\m@ne
          \thesection\quad
        \fi
        ##1}}}}
\fi
\def\ps@myheadings{%
    \let\@oddfoot\@empty\let\@evenfoot\@empty
    \def\@evenhead{\thepage\hfil\slshape\leftmark}%
    \def\@oddhead{{\slshape\rightmark}\hfil\thepage}%
    \let\@mkboth\@gobbletwo
    \let\sectionmark\@gobble
    \let\subsectionmark\@gobble
    }
\usepackage{ifthen}
  \if@titlepage
  \newcommand\maketitle{\begin{titlepage}%
  \let\footnotesize\small
  \let\footnoterule\relax
  \let \footnote \thanks
  \null\vfil
%  \vskip 60\p@
  \vskip 30\p@
   \begin{center}%
    {\LARGE\bf \@title \par}%
    \ifthenelse{\not\equal{\@Subtitle}{}}{
      \vskip 1.5em
      {\Large\bf\sl \@Subtitle \par}
    }{}
    \vskip 3em%
    {\large
     \lineskip .75em%
      \begin{tabular}[t]{c}%
        \@author
      \end{tabular}\par}%
      \vskip 1.5em%
%    {\large \@date \par}%       % Set date in \large size.
    \@Address%
   \end{center}\par
  {\bf\quad{}\@Abstract\par}%
%VW  {\small\bf\quad{}\@Abstract\par}%
  \ifthenelse{\not\equal{\@Keywords}{}}{
    \vskip 0.5em
    {\bf\quad{}\keywordsname --- \quad{}\@Keywords{}\par}
%VW    {\small\bf\quad{}\keywordsname --- \quad{}\@Keywords\par}
  }{}
  \@thanks
  \vfil\null
  \end{titlepage}%
  \setcounter{footnote}{0}%
  \global\let\thanks\relax
  \global\let\maketitle\relax
  \global\let\@thanks\@empty
  \global\let\@author\@empty
  \global\let\@date\@empty
  \global\let\@title\@empty
  \global\let\title\relax
  \global\let\author\relax
  \global\let\date\relax
  \global\let\and\relax
  \global\let\@Address\@empty
  \global\let\Address\relax
  \global\let\@Abstract\@empty
  \global\let\Abstract\relax
  \global\let\@Keywords\@empty
  \global\let\Keywords\relax
}
\else
\newcommand\maketitle{\par
  \begingroup
    \renewcommand\thefootnote{\@fnsymbol\c@footnote}%
    \def\@makefnmark{\rlap{\@textsuperscript{\normalfont\@thefnmark}}}%
    \long\def\@makefntext##1{\parindent 1em\noindent
            \hb@xt@1.8em{%
                \hss\@textsuperscript{\normalfont\@thefnmark}}##1}%
    \if@twocolumn
      \ifnum \col@number =\@ne
        \@maketitle
      \else
        \twocolumn[\@maketitle]%
      \fi
    \else
      \newpage
      \global\@topnum\z@   % Prevents figures from going at top of page.
      \@maketitle
    \fi
    \thispagestyle{plain}\@thanks
  \endgroup
  \setcounter{footnote}{0}%
  \global\let\thanks\relax
  \global\let\maketitle\relax
  \global\let\@maketitle\relax
  \global\let\@thanks\@empty
  \global\let\@author\@empty
  \global\let\@date\@empty
  \global\let\@title\@empty
  \global\let\title\relax
  \global\let\author\relax
  \global\let\date\relax
  \global\let\and\relax
  \global\let\@Address\@empty
  \global\let\Address\relax
  \global\let\@Abstract\@empty
  \global\let\Abstract\relax
  \global\let\@Keywords\@empty
  \global\let\Keywords\relax
}
\def\@maketitle{%
  \newpage
  \null
%  \vskip 2em%
  \vskip 1em%
 %% \begin{center}%
  %% \let \footnote \ {}
\parbox[c][2.2cm][c]{\textwidth}{\vskip -13mm\includegraphics[width = \textwidth]{\@MSR_Head} \vskip -9mm{{ }\hfill{Journal homepage: \href{https://content.sciendo.com/view/journals/msr/msr-overview.xml}{https://content.sciendo.com}}\hfill{ }}}
%\vskip 2.5mm\rule{\textwidth}{2pt}
\vskip 2em
    {\LARGE\bf \@title \par}%
    \ifthenelse{\not\equal{\@Subtitle}{}}{
      \vskip 0.75em
      {\Large\bf\sl \@Subtitle \par}
    }{}
    \vskip 1.5em%
    {\large
      \lineskip .5em%
      \begin{tabular}[t]{c}%
	\hskip -6pt\@author
      \end{tabular}\par}%
    \vskip 1em%
%    {\large \@date}%
    \emph{\@Address}%
%%  \end{center}%
  \par
\vskip 2em
%  {\bf\quad{} {}\@Abstract\par}%
% {\abstractname:{}\ \@Abstract\par}%
  {\small Abstract: \@Abstract\par}% AK
  \ifthenelse{\not\equal{\@Keywords}{}}{
    \vskip 0.5em
    {\keywordsname{}: {}\@Keywords{}\par}
%   {\bf\quad{}\keywordsname{} --- {}\@Keywords{}\par}
  }{}\vskip 1em\hrule\vskip 2em}
\fi
%AK \setcounter{secnumdepth}{3}
\setcounter{secnumdepth}{2}
\newcounter {part}
\newcounter {section}
\newcounter {subsection}[section]
\newcounter {subsubsection}[subsection]
\newcounter {paragraph}[subsubsection]
\newcounter {subparagraph}[paragraph]
\renewcommand \thepart {\@Roman\c@part}
\renewcommand \thesection {\@arabic\c@section}
%AK \renewcommand\thesubsection {\thesection.\@arabic\c@subsection}
\renewcommand\thesubsection {\@Alph\c@subsection}
\renewcommand\thesubsubsection{\c@subsubsection}
\renewcommand\theparagraph    {\thesubsubsection.\@arabic\c@paragraph}
\renewcommand\thesubparagraph {\theparagraph.\@arabic\c@subparagraph}
\newcommand\part{%
   \if@noskipsec \leavevmode \fi
   \par
   \addvspace{4ex}%
   \@afterindentfalse
   \secdef\@part\@spart}

\def\@part[#1]#2{%
    \ifnum \c@secnumdepth >\m@ne
      \refstepcounter{part}%
      \addcontentsline{toc}{part}{\thepart\hspace{1em}#1}%
    \else
      \addcontentsline{toc}{part}{#1}%
    \fi
    {\parindent \z@ \raggedright
     \interlinepenalty \@M
     \normalfont
     \ifnum \c@secnumdepth >\m@ne
       \Large\bfseries \partname\nobreakspace\thepart
       \par\nobreak
     \fi
     \huge \bfseries #2%
     \markboth{}{}\par}%
    \nobreak
    \vskip 3ex
    \@afterheading}
\def\@spart#1{%
    {\parindent \z@ \raggedright
     \interlinepenalty \@M
     \normalfont
     \huge \bfseries #1\par}%
     \nobreak
     \vskip 3ex
     \@afterheading}
%\usepackage{smallcap}
\newcommand\section{\@startsection {section}{1}{\z@}%
																	 {-10pt \@plus 4pt \@minus -4pt}% AK
																	 {4pt \@plus 4pt \@minus -4pt}% AK
% AK                                   {-3.5ex \@plus -1ex \@minus -.2ex}%
% AK                                   {0.5ex \@plus .2ex}%
%                                  {2.3ex \@plus .2ex}%
%                                   {\normalfont\Large\bfseries}}
%                                   {\normalfont\centering\normalsize\scfamily}} % Only with 'smallcap' package
%                                   {\normalfont\centering\large\sc}}
%                                   {\normalfont\centering\normalsize\sc}}
				   {\normalfont\normalsize\sc}}
\newcommand\subsection{\@startsection{subsection}{2}{\z@}%
																	 {-10pt \@plus 4pt \@minus -4pt}% AK
																	 {4pt \@plus 4pt \@minus -4pt}% AK
% AK                                     {-3.25ex \@plus -1ex \@minus -.2ex}%
% AK                                     {0.5ex \@plus .2ex}%
%                                    {1.5ex \@plus .2ex}%
%                                     {\normalfont\large\bfseries}}
%                                     {\normalfont\normalsize\scfamily\slshape}} % Only with 'smallcap' package
                                     {\normalfont\normalsize\slshape}}
\newcommand\subsubsection{\@startsection{subsubsection}{3}{\z@}%
																	 {-10pt \@plus 4pt \@minus -4pt}% AK
																	 {4pt \@plus 4pt \@minus -4pt}% AK
% AK                                     {-3.25ex \@plus -1ex \@minus -.2ex}%
% AK                                     {0.5ex \@plus .2ex}%
%                                    {1.5ex \@plus .2ex}%
                                     {\normalfont\normalsize\slshape}}
\newcommand\paragraph{\@startsection{paragraph}{4}{\z@}%
																	 {-10pt \@plus 4pt \@minus -4pt}% AK
																	 {4pt \@plus 4pt \@minus -4pt}% AK
% AK                                    {3.25ex \@plus 1ex \@minus .2ex}%
% AK                                    {-1em}%
                                    {\normalfont\normalsize\bfseries}}
\newcommand\subparagraph{\@startsection{subparagraph}{5}{\parindent}%
																	 {-10pt \@plus 4pt \@minus -4pt}% AK
																	 {4pt \@plus 4pt \@minus -4pt}% AK
% AK                                       {3.25ex \@plus 1ex \@minus .2ex}%
% AK                                       {-1em}%
                                      {\normalfont\normalsize\bfseries}}
\if@twocolumn
  \setlength\leftmargini  {2em}
\else
  \setlength\leftmargini  {2.5em}
\fi
\leftmargin  \leftmargini
\setlength\leftmarginii  {2.2em}
\setlength\leftmarginiii {1.87em}
\setlength\leftmarginiv  {1.7em}
\if@twocolumn
  \setlength\leftmarginv  {.5em}
  \setlength\leftmarginvi {.5em}
\else
  \setlength\leftmarginv  {1em}
  \setlength\leftmarginvi {1em}
\fi
\setlength  \labelsep  {.5em}
\setlength  \labelwidth{\leftmargini}
\addtolength\labelwidth{-\labelsep}
\@beginparpenalty -\@lowpenalty
\@endparpenalty   -\@lowpenalty
\@itempenalty     -\@lowpenalty
\renewcommand\theenumi{\@arabic\c@enumi}
\renewcommand\theenumii{\@alph\c@enumii}
\renewcommand\theenumiii{\@roman\c@enumiii}
\renewcommand\theenumiv{\@Alph\c@enumiv}
\newcommand\labelenumi{\theenumi.}
\newcommand\labelenumii{(\theenumii)}
\newcommand\labelenumiii{\theenumiii.}
\newcommand\labelenumiv{\theenumiv.}
\renewcommand\p@enumii{\theenumi}
\renewcommand\p@enumiii{\theenumi(\theenumii)}
\renewcommand\p@enumiv{\p@enumiii\theenumiii}
\newcommand\labelitemi{\textbullet}
\newcommand\labelitemii{\normalfont\bfseries \textendash}
\newcommand\labelitemiii{\textasteriskcentered}
\newcommand\labelitemiv{\textperiodcentered}
\newenvironment{description}
               {\list{}{\labelwidth\z@ \itemindent-\leftmargin
                        \let\makelabel\descriptionlabel}}
               {\endlist}
\newcommand*\descriptionlabel[1]{\hspace\labelsep
                                \normalfont\bfseries #1}
\if@titlepage
  \newenvironment{abstract}{%
      \titlepage
      \null\vfil
      \@beginparpenalty\@lowpenalty
      \begin{center}%
        \bfseries \abstractname
        \@endparpenalty\@M
      \end{center}}%
     {\par\vfil\null\endtitlepage}
\else
  \newenvironment{abstract}{%
      \if@twocolumn
        \section*{\abstractname}%
      \else
        \small
        \begin{center}%
          {\bfseries \abstractname\vspace{-.5em}\vspace{\z@}}%
        \end{center}%
        \quotation
      \fi}
      {\if@twocolumn\else\endquotation\fi}
\fi
\newenvironment{verse}
               {\let\\\@centercr
                \list{}{\itemsep      \z@
                        \itemindent   -1.5em%
                        \listparindent\itemindent
                        \rightmargin  \leftmargin
                        \advance\leftmargin 1.5em}%
                \item\relax}
               {\endlist}
\newenvironment{quotation}
               {\list{}{\listparindent 1.5em%
                        \itemindent    \listparindent
                        \rightmargin   \leftmargin
                        \parsep        \z@ \@plus\p@}%
                \item\relax}
               {\endlist}
\newenvironment{quote}
               {\list{}{\rightmargin\leftmargin}%
                \item\relax}
               {\endlist}
\if@compatibility
\newenvironment{titlepage}
    {%
      \if@twocolumn
        \@restonecoltrue\onecolumn
      \else
        \@restonecolfalse\newpage
      \fi
      \thispagestyle{empty}%
      \setcounter{page}\z@
    }%
    {\if@restonecol\twocolumn \else \newpage \fi
    }
\else
\newenvironment{titlepage}
    {%
      \if@twocolumn
        \@restonecoltrue\onecolumn
      \else
        \@restonecolfalse\newpage
      \fi
      \thispagestyle{empty}%
      \setcounter{page}\@ne
    }%
    {\if@restonecol\twocolumn \else \newpage \fi
     \if@twoside\else
        \setcounter{page}\@ne
     \fi
    }
\fi
%
%\def\appendixname{Appendix }
%\renewcommand\appendix{\par
%  \setcounter{section}{0}%
%  \setcounter{subsection}{0}%
%  \setcounter{equation}{0}
%  \gdef\thefigure{\@Alph\c@section.\arabic{figure}}%
%  \gdef\thetable{\@Alph\c@section.\arabic{table}}%
%  \gdef\thesection{\appendixname~\@Alph\c@section}%
%  \@addtoreset{equation}{section}%
%  \gdef\theequation{\@Alph\c@section.\arabic{equation}}%
%  \addtocontents{toc}{\string\let\string\numberline\string\tmptocnumberline}{}{}
%}
\newcommand\appendix{\par
 \setcounter{section}{0}%
  \setcounter{subsection}{0}%
  \gdef\thesection{\@Alph\c@section}} 
\setlength\arraycolsep{5\p@}
\setlength\tabcolsep{6\p@}
\setlength\arrayrulewidth{.4\p@}
\setlength\doublerulesep{2\p@}
\setlength\tabbingsep{\labelsep}
\skip\@mpfootins = \skip\footins
\setlength\fboxsep{3\p@}
\setlength\fboxrule{.4\p@}
\renewcommand \theequation {\@arabic\c@equation}
\newcounter{figure}
\renewcommand \thefigure {\@arabic\c@figure}
\def\fps@figure{tbp}
\def\ftype@figure{1}
\def\ext@figure{lof}
\def\fnum@figure{\figurename\nobreakspace\thefigure} %% VW: Frolo nechce medzeru
\newenvironment{figure}
               {\@float{figure}}
               {\end@float}
\newenvironment{figure*}
               {\@dblfloat{figure}}
               {\end@dblfloat}
\newcounter{table}
\renewcommand\thetable{\@arabic\c@table}
\def\fps@table{tbp}
\def\ftype@table{2}
\def\ext@table{lot}
\def\fnum@table{\tablename\nobreakspace\thetable}
\newenvironment{table}
               {\@float{table}}
               {\end@float}
\newenvironment{table*}
               {\@dblfloat{table}}
               {\end@dblfloat}
\newlength\abovecaptionskip
\newlength\belowcaptionskip
\setlength\abovecaptionskip{10\p@}
\setlength\belowcaptionskip{0\p@}
%\setlength\abovecaptionskip{6\p@}
%\setlength\belowcaptionskip{6\p@}
%\setlength\abovecaptionskip{10\p@}
%\setlength\belowcaptionskip{-15\p@}
\long\def\@makecaption#1#2{%
  \vskip\abovecaptionskip
  \sbox\@tempboxa{#1: #2}%
  \ifdim \wd\@tempboxa >\hsize
   #1: #2\par
  \else
    \global \@minipagefalse
    \hb@xt@\hsize{\hfil\box\@tempboxa\hfil}%
  \fi
  \vskip\belowcaptionskip}
\DeclareOldFontCommand{\rm}{\normalfont\rmfamily}{\mathrm}
\DeclareOldFontCommand{\sf}{\normalfont\sffamily}{\mathsf}
\DeclareOldFontCommand{\tt}{\normalfont\ttfamily}{\mathtt}
\DeclareOldFontCommand{\bf}{\normalfont\bfseries}{\mathbf}
\DeclareOldFontCommand{\it}{\normalfont\itshape}{\mathit}
\DeclareOldFontCommand{\sl}{\normalfont\slshape}{\@nomath\sl}
\DeclareOldFontCommand{\sc}{\normalfont\scshape}{\@nomath\sc}
\DeclareRobustCommand*\cal{\@fontswitch\relax\mathcal}
\DeclareRobustCommand*\mit{\@fontswitch\relax\mathnormal}
\newcommand\@pnumwidth{1.55em}
\newcommand\@tocrmarg{2.55em}
\newcommand\@dotsep{4.5}
\setcounter{tocdepth}{3}
\newcommand\tableofcontents{%
    \section*{\contentsname
        \@mkboth{%
           \MakeUppercase\contentsname}{\MakeUppercase\contentsname}}%
    \@starttoc{toc}%
    }
\newcommand*\l@part[2]{%
  \ifnum \c@tocdepth >-2\relax
    \addpenalty\@secpenalty
    \addvspace{2.25em \@plus\p@}%
    \setlength\@tempdima{3em}%
    \begingroup
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      {\leavevmode
       \large \bfseries #1\hfil \hb@xt@\@pnumwidth{\hss #2}}\par
       \nobreak
       \if@compatibility
         \global\@nobreaktrue
         \everypar{\global\@nobreakfalse\everypar{}}%
      \fi
    \endgroup
  \fi}
\newcommand*\l@section[2]{%
  \ifnum \c@tocdepth >\z@
    \addpenalty\@secpenalty
    \addvspace{1.0em \@plus\p@}%
    \setlength\@tempdima{1.5em}%
    \begingroup
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      \leavevmode \bfseries
      \advance\leftskip\@tempdima
      \hskip -\leftskip
      #1\nobreak\hfil \nobreak\hb@xt@\@pnumwidth{\hss #2}\par
    \endgroup
  \fi}
\newcommand*\l@subsection{\@dottedtocline{2}{1.5em}{2.3em}}
\newcommand*\l@subsubsection{\@dottedtocline{3}{3.8em}{3.2em}}
\newcommand*\l@paragraph{\@dottedtocline{4}{7.0em}{4.1em}}
\newcommand*\l@subparagraph{\@dottedtocline{5}{10em}{5em}}
\newcommand\listoffigures{%
    \section*{\listfigurename}%
      \@mkboth{\MakeUppercase\listfigurename}%
              {\MakeUppercase\listfigurename}%
    \@starttoc{lof}%
    }
\newcommand*\l@figure{\@dottedtocline{1}{1.5em}{2.3em}}
\newcommand\listoftables{%
    \section*{\listtablename}%
      \@mkboth{%
          \MakeUppercase\listtablename}%
         {\MakeUppercase\listtablename}%
    \@starttoc{lot}%
    }
\let\l@table\l@figure
\newdimen\bibindent
\setlength\bibindent{1.5em}
\newenvironment{thebibliography}[1]
     {\section*{\refname}%
      \@mkboth{\MakeUppercase\refname}{\MakeUppercase\refname}%
      \list{\@biblabel{\@arabic\c@enumiv}}%
           {\settowidth\labelwidth{\@biblabel{#1}}%
            \leftmargin\labelwidth
            \advance\leftmargin\labelsep
            \@openbib@code
            \usecounter{enumiv}%
            \let\p@enumiv\@empty
            \renewcommand\theenumiv{\@arabic\c@enumiv}}%
      \sloppy
      \clubpenalty4000
      \@clubpenalty \clubpenalty
      \widowpenalty4000%
      \sfcode`\.\@m}
     {\def\@noitemerr
       {\@latex@warning{Empty `thebibliography' environment}}%
      \endlist}
\newcommand\newblock{\hskip .11em\@plus.33em\@minus.07em}
\let\@openbib@code\@empty
\newenvironment{theindex}
               {\if@twocolumn
                  \@restonecolfalse
                \else
                  \@restonecoltrue
                \fi
                \twocolumn[\section*{\indexname}]%
                \@mkboth{\MakeUppercase\indexname}%
                        {\MakeUppercase\indexname}%
                \thispagestyle{plain}\parindent\z@
                \parskip\z@ \@plus .3\p@\relax
                \columnseprule \z@
                \columnsep 35\p@
                \let\item\@idxitem}
               {\if@restonecol\onecolumn\else\clearpage\fi}
\newcommand\@idxitem{\par\hangindent 40\p@}
\newcommand\subitem{\@idxitem \hspace*{20\p@}}
\newcommand\subsubitem{\@idxitem \hspace*{30\p@}}
\newcommand\indexspace{\par \vskip 10\p@ \@plus5\p@ \@minus3\p@\relax}
\renewcommand\footnoterule{%
  \kern-3\p@
  \hrule\@width.4\columnwidth
  \kern2.6\p@}
\newcommand\@makefntext[1]{%
    \parindent 1em%
    \noindent
    \hb@xt@1.8em{\hss\@makefnmark}#1}
\newcommand\contentsname{Contents}
\newcommand\listfigurename{List of Figures}
\newcommand\listtablename{List of Tables}
\newcommand\refname{References}
\newcommand\indexname{Index}
\newcommand\figurename{Figure}
\newcommand\tablename{Table}
\newcommand\partname{Part}
\newcommand\appendixname{Appendix}
\newcommand\abstractname{Abstract}
\def\today{\ifcase\month\or
  January\or February\or March\or April\or May\or June\or
  July\or August\or September\or October\or November\or December\fi
  \space\number\day, \number\year}
\setlength\columnsep{15\p@}
% VW \setlength\columnsep{10\p@}
\setlength\columnseprule{0\p@}
\pagestyle{plain}
\pagenumbering{arabic}
\if@twoside
\else
  \raggedbottom
\fi
\if@twocolumn
  \twocolumn
  \sloppy
  \flushbottom
\else
  \onecolumn
\fi

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Page format

\usepackage[a4paper]{geometry}
%\geometry{tmargin=3cm,bmargin=3cm,lmargin=1.7cm,rmargin=1.7cm,headheight=23pt,foot=1.5cm,top=3.2cm}
%\geometry{tmargin=2.5cm,bmargin=2.5cm,lmargin=1.65cm,rmargin=1.65cm,headheight=23pt,foot=1.5cm,top=3.2cm}
\geometry{top=2.5cm,bottom=2.5cm,left=1.65cm,right=1.65cm,foot=1.5cm,headheight=0.76cm}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Default fonts

\usepackage{mathptmx}
\usepackage{helvet}
\usepackage{courier}
\renewcommand{\familydefault}{\rmdefault}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Caption fonts

%\usepackage{caption}
%\renewcommand{\captionfont}{\small}
%\renewcommand{\captionlabelfont}{\small\rm}

%\DeclareCaptionLabelSeparator{hskip}{.\hskip 4px} 															% AK
%\usepackage[figurename=Fig.\hskip -1.75px, labelsep=hskip, font={small,rm}, labelfont={small,rm}, textfont={small,rm}]{caption} 	% AK

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Hyperref

\usepackage[colorlinks=true,urlcolor=black,linkcolor=black,citecolor=black]{hyperref}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Url font

\renewcommand\UrlFont{\ttfamily\small}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Title page macros

%\newcommand\keywordsname{\small Keywords}
%\newcommand\abstractname{\small Abstract} % AK
\newcommand\keywordsname{\small Keywords}%VW

\def\Subtitle#1{\gdef\@Subtitle{#1}}
\def\@Subtitle{}

\def\Address#1{\gdef\@Address{#1}}
\def\@Address{}

% \def\Abstract#1{\gdef\@Abstract#1}}
\def\Abstract#1{\gdef\@Abstract{\small #1}}%VW
\def\@Abstract{}

%\def\Keywords#1{\gdef\@Keywords{#1}}
\def\Keywords#1{\gdef\@Keywords{\small #1}}%VW
\def\@Keywords{}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Theorem, Lemma, Corollary, Proof definitions

\usepackage{amsthm}

\newcommand\theoremname{Theorem}
\newcommand\lemmaname{Lemma}
\newcommand\corollaryname{Corollary}

\newtheorem{theorem}{\theoremname}
\newtheorem{lemma}{\lemmaname}
\newtheorem{corollary}{\corollaryname}

\newcommand\Theorem[1]{\begin{theorem}#1\end{theorem}}
\newcommand\Lemma[1]{\begin{lemma}#1\end{lemma}}
\newcommand\Corollary[1]{\begin{corollary}#1\end{corollary}}
\newcommand\Proof[1]{\begin{proof}#1\end{proof}}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Headings with journal insignia

\def\Journal#1{\gdef\@Journal{#1}}
\def\@Journal{MEASUREMENT SCIENCE REVIEW, \textbf{xx}(x), 20xx, xxx--xxx}

\def\MSR_Head#1{\gdef\@MSR_Head{#1}}
\def\@MSR_Head{MSRhead.eps}

\def\Doi#1{\gdef\@Doi{#1}}
\def\@Doi{10.1515/msr-2016-xxxx}
\def\Correspondance#1{\gdef\@Correspondance{#1}}
\def\@Correspondance#1{#1}

\usepackage{fancyhdr}
\pagestyle{fancy}

\fancyhf{}
\lhead{}
\chead{\@Journal}
\rhead{}
\cfoot{\thepage}
\renewcommand{\headrulewidth}{0pt}
\renewcommand{\footrulewidth}{0pt}

\fancypagestyle{plain}{
  \fancyhf{}
  \lhead{}
  \chead{\@Journal}
  \rhead{}
  \lfoot{\vskip -1.25cm\noindent\rule{3.35cm}{0.4pt}\newline\footnotesize\href{http://dx.doi.org/\@Doi}{DOI:\ \@Doi}}
  \cfoot{\thepage}
  \rfoot{\vskip -1.25cm\noindent\newline\footnotesize{\em \@Correspondance}}
 %VW \rfoot{\footnotesize\href{http://www.degruyter.com/view/j/msr}{Journal homepage: http://www.degruyter.com/view/j/msr}}
 %\fancyfoot[L]{%\rule{24mm}{1pt}\\\footnotesize\href{http://dx.doi.org/\@Doi}{DOI:\ \@Doi}\vskip 0.5em} 

  \renewcommand{\headrulewidth}{0pt}
  \renewcommand{\footrulewidth}{0pt}
}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Babel string modifications

\usepackage{babel}
\addto\captionsenglish{
%  \renewcommand\proofname{\scfamily\upshape Proof} % Only with 'smallcap' package
  \renewcommand\proofname{\upshape\sc Proof}
% AK  \renewcommand\figurename{Fig.}
}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% AK
% AK New code float environment, caption settings, and paragraph identation
\newcounter{code} 
\usepackage{float}
\floatstyle{ruled}
\newfloat{code}{htbp}{loc}[code]
\floatname{code}{\small\rm Code}
\renewcommand \thecode {\@arabic\c@code}

\usepackage{caption}
%\DeclareCaptionLabelSeparator{hskip}{.\hskip 4px}
\DeclareCaptionLabelSeparator{hskip}{.\hskip 4px}
\usepackage[labelsep=hskip, font={small,rm}, labelfont={small,rm}, textfont={small,rm}]{caption}
%\captionsetup[figure]{name=Fig.\hskip -1.75px}
\captionsetup[figure]{name=Fig.~}
\captionsetup[code]{style=base}
\captionsetup[code]{labelsep=hskip, font={small,rm}, labelfont={small,rm}, textfont={small,rm}}

\setlength{\parindent}{0.36cm}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Dot after section numbers

\usepackage{secdot}
\sectiondot{subsection}
\sectiondot{subsubsection}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Space between bibliography items and balancing columns at the last page

\usepackage{balance}
\let\thebibliographyorig=\thebibliography
\let\endthebibliographyorig=\endthebibliography
  \balance
\renewenvironment{thebibliography}[1]{
  \begin{thebibliographyorig}{#1}
  \setlength{\parskip}{0.1em}
  \setlength{\itemsep}{0.1em}
}
{
  \end{thebibliographyorig}
}

\endinput
%%
%% End of file `MSRarticle.cls'.
